;***********************************************************************************************************************
;* 150130-03                                 -   
;***********************************************************************************************************************
.MACRO  INIT_ANOTHER_PORTS              ;    -:

        ldi     temp,0b00000000         ; PORTA: !!!  ATMEGA48PA   
        out     DDRA,temp
                                        ; PA7 -   -  
                                        ; PA6 -   -  
                                        ; PA5 -   -  
                                        ; PA4 -   -  
                                        ; PA3 -   -  
                                        ; PA2 -   -  
                                        ; PA1 -   -  
                                        ; PA0 -   -  
                                
        ldi     temp,0b00111000         ; PORTB:
        out     DDRB,temp
                                        ; PB7 -   -   ()
                                        ; PB6 -   -   ()
                                        ; PB5 -  - REG_SHIFT -      
                                        ; PB4 -  - REG_DATA  -      
                                        ; PB3 -  - REG_LATCH -    
                                        ; PB2 -   - SEGA1_4   - 1 SEGA  4 
                                        ; PB1 -   - SEGA1_2   - 1 SEGA  2 
                                        ; PB0 -   - SEGA1_1   - 1 SEGA  1 

;         ldi     temp,0b00000000         ; PORTC: !!!  ATMEGA3515   
;         out     DDRC,temp
;                                         ; PC7 -   - 
;                                         ; PC6 -   -   (RESET)
;                                         ; PC5 -   - SEGA2_6   - 2 SEGA  6 
;                                         ; PC4 -   - SEGA2_2   - 2 SEGA  2 
;                                         ; PC3 -   - SEGA2_1   - 2 SEGA  1 
;                                         ; PC2 -   - SEGA2_3   - 2 SEGA  3 
;                                         ; PC1 -   - SEGA2_4   - 2 SEGA  4 
;                                         ; PC0 -   - SEGA2_9   - 2 SEGA  9 

        ldi     temp,0b00010010         ; PORTD:
        out     DDRD,temp
                                        ; PD7 -   - SEGA1_3   - 1 SEGA  3 
                                        ; PD6 -   - SEGA1_9   - 1 SEGA  9 
                                        ; PD5 -   - SEGA1_6   - 1 SEGA  6 
                                        ; PD4 -  - SEGA12_7  - 1  2 SEGA  7  - 
                                        ; PD3 -   - KEYB_CLK  -  PS2 ,     !!!
                                        ; PD2 -   - KEYB_DATA -    PS2 ,     !!!
                                        ; PD1 -  - TX - ,   UART
                                        ; PD0 -   - RX - ,     UART

        ldi     temp,0b00000000         ; PORTE: !!!  ATMEGA48PA   
        out     DDRE,temp
                                        ; PE7 -   - 
                                        ; PE6 -   - 
                                        ; PE5 -   - 
                                        ; PE4 -   - 
                                        ; PE3 -   - 
                                        ; PE2 -   -  
                                        ; PE1 -   -  
                                        ; PE0 -   -  
.ENDMACRO               
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  CLR_REG_DATA                    ;       0     
        cbi     PORTB,4
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  SET_REG_DATA                    ;   1     
        sbi     PORTB,4
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  CLR_REG_SHIFT                   ;       0     
        cbi     PORTB,5
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  SET_REG_SHIFT                   ;   1     
        sbi     PORTB,5
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  CLR_REG_LATCH                   ;       0     
        cbi     PORTB,3
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  SET_REG_LATCH                   ;   1     
        sbi     PORTB,3
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  CLR_SEGA12_7                    ;       0   SEGA 
        cbi     PORTD,4
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  SET_SEGA12_7                    ;   1   SEGA 
        sbi     PORTD,4
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------


;-----------------------------------------------------------------------------------------------------------------------
.MACRO  CLR_DIGITAL_OUT                 ;   0    
        cbi     PORTA,4
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  SET_DIGITAL_OUT                 ;   1    
        sbi     PORTA,4
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  TST_DIGITAL_IN                  ;     
        in      temp2,PINA              ;    0,  temp2   0
        andi    temp2,0b00100000
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  TST_FIFO_RXF                    ;  FIFO_RXF -       
        in      temp2,PINA              ;    0,  temp2   0
        andi    temp2,0b00000010
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  TST_FIFO_TXE                    ;  FIFO_TXE -      
        in      temp2,PINA              ;    0,  temp2   0
        andi    temp2,0b00000001
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  OUT_SEGMENTS                    ;       
        out     PORTD,temp2
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  ON_LED_PLAY                     ;   PLAY
        cbi     PORTE,2
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  OFF_LED_PLAY                    ;   PLAY
        sbi     PORTE,2
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  ON_LED_PAUSE                    ;   PAUSE
        cbi     PORTE,1
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  OFF_LED_PAUSE                   ;   PAUSE
        sbi     PORTE,1
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  ON_LED_RECORD                   ;   RECORD
        cbi     PORTE,0
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  OFF_LED_RECORD                  ;   RECORD
        sbi     PORTE,0
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  ON_FIFO_RD                      ;     FIFO 
        cbi     PORTA,3
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  OFF_FIFO_RD                     ;     FIFO 
        sbi     PORTA,3
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  ON_FIFO_WR                      ;     FIFO 
        cbi     PORTA,2
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  OFF_FIFO_WR                     ;    FIFO 
        sbi     PORTA,2
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  ON_DIGIT0                       ;     
        cbi     PORTA,7
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  OFF_DIGIT0                      ;     
        sbi     PORTA,7
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  ON_DIGIT1                       ;     
        cbi     PORTA,6
.ENDMACRO
;-----------------------------------------------------------------------------------------------------------------------
.MACRO  OFF_DIGIT1                      ;     
        sbi     PORTA,6
.ENDMACRO

